/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CombatCalligrapherEffect
extends RestrictionEffect {
    CombatCalligrapherEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Inklings can't attack you or planeswalkers you control";
    }

    private CombatCalligrapherEffect(CombatCalligrapherEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.hasSubtype(SubType.INKLING, game);
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (source.isControlledBy(defenderId)) {
            return false;
        }
        Permanent planeswalker = game.getPermanent(defenderId);
        return planeswalker == null || !planeswalker.isControlledBy(source.getControllerId());
    }

    public CombatCalligrapherEffect copy() {
        return new CombatCalligrapherEffect(this);
    }
}

