/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.common.delayed.AtTheBeginOfPlayersNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ComeBackWrongEffect
extends OneShotEffect {
    ComeBackWrongEffect() {
        super(Outcome.Neutral);
        this.staticText = "destroy target creature. If a creature card is put into a graveyard this way, return it to the battlefield under your control. Sacrifice it at the beginning of your next end step";
    }

    private ComeBackWrongEffect(ComeBackWrongEffect effect) {
        super((OneShotEffect)effect);
    }

    public ComeBackWrongEffect copy() {
        return new ComeBackWrongEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        permanent.destroy(source, game);
        if (permanent instanceof PermanentToken) {
            return true;
        }
        Card card = permanent.getMainCard();
        if (card == null || !card.isCreature(game) || !Zone.GRAVEYARD.match(game.getState().getZone(card.getId()))) {
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return true;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent creature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (creature != null) {
            game.addDelayedTriggeredAbility(new AtTheBeginOfPlayersNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect("sacrifice it").setTargetPointer((TargetPointer)new FixedTarget(creature, game)), player.getId()).setTriggerPhrase("At the beginning of your next end step, "), source);
        }
        return true;
    }
}

