/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;
import mage.watchers.common.CommanderPlaysCountWatcher;

class CommandersInsightEffect
extends OneShotEffect {
    CommandersInsightEffect() {
        super(Outcome.Benefit);
        this.staticText = "target player draws X cards plus an additional card for each time they've cast a commander from the command zone this game";
    }

    private CommandersInsightEffect(CommandersInsightEffect effect) {
        super((OneShotEffect)effect);
    }

    public CommandersInsightEffect copy() {
        return new CommandersInsightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        CommanderPlaysCountWatcher watcher = (CommanderPlaysCountWatcher)game.getState().getWatcher(CommanderPlaysCountWatcher.class);
        if (player == null || watcher == null) {
            return false;
        }
        int toDraw = watcher.getPlayerCount(player.getId()) + (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        return player.drawCards(toDraw, source, game) > 0;
    }
}

