/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Set;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterMana;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CommandersPlateEffect
extends ContinuousEffectImpl {
    CommandersPlateEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "has protection from each color that's not in your commander's color identity";
        this.generateGainAbilityDependencies((Ability)ProtectionAbility.from((ObjectColor)new ObjectColor("WUBRG")), null);
        this.concatBy("and");
    }

    private CommandersPlateEffect(CommandersPlateEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public CommandersPlateEffect copy() {
        return new CommandersPlateEffect(this);
    }

    public void init(Ability source, Game game) {
        if (!this.getAffectedObjectsSetAtInit(source)) {
            return;
        }
        Permanent equipment = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (equipment == null || equipment.getAttachedTo() == null) {
            this.discard();
            return;
        }
        this.setTargetPointer((TargetPointer)new FixedTarget(equipment.getAttachedTo(), game));
        super.init(source, game);
    }

    public boolean apply(Game game, Ability source) {
        Set commanders;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Permanent permanent = null;
        if (this.getAffectedObjectsSet()) {
            permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent == null) {
                this.discard();
                return true;
            }
        } else {
            Permanent equipment = game.getPermanent(source.getSourceId());
            if (equipment != null && equipment.getAttachedTo() != null) {
                permanent = game.getPermanentOrLKIBattlefield(equipment.getAttachedTo());
            }
        }
        if ((commanders = game.getCommandersIds(player, CommanderCardType.COMMANDER_OR_OATHBREAKER, false)).isEmpty()) {
            return false;
        }
        ObjectColor color = new ObjectColor("WUBRG");
        for (UUID commanderId : commanders) {
            Card card = game.getCard(commanderId);
            if (card == null) continue;
            FilterMana identity = card.getColorIdentity();
            if (identity.isWhite()) {
                color.setWhite(false);
            }
            if (identity.isBlue()) {
                color.setBlue(false);
            }
            if (identity.isBlack()) {
                color.setBlack(false);
            }
            if (identity.isRed()) {
                color.setRed(false);
            }
            if (!identity.isGreen()) continue;
            color.setGreen(false);
        }
        if (permanent != null) {
            permanent.addAbility((Ability)ProtectionAbility.from((ObjectColor)color), source.getSourceId(), game);
        }
        return true;
    }
}

