/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class CommitEffect
extends OneShotEffect {
    CommitEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put target spell or nonland permanent into its owner's library second from the top";
    }

    private CommitEffect(CommitEffect effect) {
        super((OneShotEffect)effect);
    }

    public CommitEffect copy() {
        return new CommitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent permanent = game.getPermanent(source.getFirstTarget());
            if (permanent != null) {
                return controller.putCardOnTopXOfLibrary((Card)permanent, game, source, 2, true);
            }
            Spell spell = game.getStack().getSpell(source.getFirstTarget());
            if (spell != null) {
                return controller.putCardOnTopXOfLibrary((Card)spell, game, source, 2, true);
            }
        }
        return false;
    }
}

