/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.filter.predicate.permanent.EnchantedPredicate;
import mage.filter.predicate.permanent.EquippedPredicate;
import mage.game.permanent.token.SpiritToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ConcordWithTheKami
extends CardImpl {
    private static final FilterPermanent counterFilter = new FilterCreaturePermanent("creature with a counter on it");
    private static final FilterPermanent enchantedFilter = new FilterControlledCreaturePermanent();
    private static final FilterPermanent equippedFilter = new FilterControlledCreaturePermanent();
    private static final Condition enchantedCondition;
    private static final Condition equippedCondition;
    private static final Hint enchantedHint;
    private static final Hint equippedHint;

    public ConcordWithTheKami(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{G}");
        BeginningOfEndStepTriggeredAbility ability = new BeginningOfEndStepTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
        ability.addTarget((Target)new TargetPermanent(counterFilter));
        ability.getModes().setMinModes(1);
        ability.getModes().setMaxModes(3);
        ability.addMode(new Mode((Effect)new ConditionalOneShotEffect((OneShotEffect)new DrawCardSourceControllerEffect(1), enchantedCondition, "draw a card if you control an enchanted creature")));
        ability.addMode(new Mode((Effect)new ConditionalOneShotEffect((OneShotEffect)new CreateTokenEffect((Token)new SpiritToken()), equippedCondition, "create a 1/1 colorless Spirit creature token if you control an equipped creature")));
        this.addAbility(ability.addHint(enchantedHint).addHint(equippedHint));
    }

    private ConcordWithTheKami(ConcordWithTheKami card) {
        super((CardImpl)card);
    }

    public ConcordWithTheKami copy() {
        return new ConcordWithTheKami(this);
    }

    static {
        counterFilter.add((Predicate)CounterAnyPredicate.instance);
        enchantedFilter.add((Predicate)EnchantedPredicate.instance);
        equippedFilter.add((Predicate)EquippedPredicate.instance);
        enchantedCondition = new PermanentsOnTheBattlefieldCondition(enchantedFilter);
        equippedCondition = new PermanentsOnTheBattlefieldCondition(equippedFilter);
        enchantedHint = new ConditionHint(enchantedCondition, "You control an enchanted creature");
        equippedHint = new ConditionHint(equippedCondition, "You control an equipped creature");
    }
}

