/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.condition.common.HaventCastSpellThisTurnCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.c.ConduitOfWorldsCantCastEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ConduitOfWorldsEffect
extends OneShotEffect {
    ConduitOfWorldsEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target nonland permanent card in your graveyard. If you haven't cast a spell this turn, you may cast that card. If you do, you can't cast additional spells this turn";
    }

    private ConduitOfWorldsEffect(ConduitOfWorldsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConduitOfWorldsEffect copy() {
        return new ConduitOfWorldsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!HaventCastSpellThisTurnCondition.instance.apply(game, source)) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null || !player.chooseUse(Outcome.Benefit, "Cast " + card.getName() + "? (You still pay the costs)", source, game)) {
            return false;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
        boolean wasCast = player.cast(player.chooseAbilityForCast(card, game, false), game, false, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        if (!wasCast) {
            return false;
        }
        game.addEffect((ContinuousEffect)new ConduitOfWorldsCantCastEffect(), source);
        return true;
    }
}

