/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class ConeOfFlameEffect
extends OneShotEffect {
    ConeOfFlameEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 1 damage to any target, 2 damage to another target, and 3 damage to a third target";
    }

    private ConeOfFlameEffect(ConeOfFlameEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConeOfFlameEffect copy() {
        return new ConeOfFlameEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean applied = false;
        int damage = 1;
        for (Target target : source.getTargets()) {
            Player player;
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                applied |= permanent.damage(damage, source.getSourceId(), source, game, false, true) > 0;
            }
            if ((player = game.getPlayer(target.getFirstTarget())) != null) {
                applied |= player.damage(damage, source.getSourceId(), source, game) > 0;
            }
            ++damage;
        }
        return applied;
    }
}

