/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ConfiscationCoupEffect
extends OneShotEffect {
    ConfiscationCoupEffect() {
        super(Outcome.GainControl);
        this.staticText = "Choose target artifact or creature. You get {E}{E}{E}{E}, then you may pay an amount of {E} equal to that permanent's mana value. If you do, gain control of it";
    }

    private ConfiscationCoupEffect(ConfiscationCoupEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConfiscationCoupEffect copy() {
        return new ConfiscationCoupEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            PayEnergyCost cost;
            new GetEnergyCountersControllerEffect(4).apply(game, source);
            Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetPermanent != null && (cost = new PayEnergyCost(targetPermanent.getManaCost().manaValue())).canPay(source, source, source.getControllerId(), game)) {
                int manaValue = targetPermanent.getManaCost().manaValue();
                StringBuilder energy = new StringBuilder(manaValue);
                for (int i = 0; i < manaValue; ++i) {
                    energy.append("{E}");
                }
                if (controller.chooseUse(this.outcome, "Pay " + energy + " to get control of " + targetPermanent.getLogName() + '?', source, game) && cost.pay(source, game, source, source.getControllerId(), true)) {
                    GainControlTargetEffect controllEffect = new GainControlTargetEffect(Duration.Custom);
                    controllEffect.setTargetPointer((TargetPointer)new FixedTarget(targetPermanent, game));
                    game.addEffect((ContinuousEffect)controllEffect, source);
                }
            }
            return true;
        }
        return false;
    }
}

