/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.ColorAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class ConfluxTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterCard("a white card, a blue card, a black card, a red card, and a green card");
    private static final ColorAssignment colorAssigner;

    ConfluxTarget() {
        super(0, 5, filter);
    }

    private ConfluxTarget(ConfluxTarget target) {
        super((TargetCardInLibrary)target);
    }

    public ConfluxTarget copy() {
        return new ConfluxTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add(card);
        return colorAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }

    static {
        filter.add(Predicates.not((Predicate)ColorlessPredicate.instance));
        colorAssigner = new ColorAssignment(new String[]{"W", "U", "B", "R", "G"});
    }
}

