/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.SharesCardTypePredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.TargetAdjuster;

enum ConfusionInTheRanksAdjuster implements TargetAdjuster
{
    instance;


    public void adjustTargets(Ability ability, Game game) {
        UUID enteringPermanentId = null;
        for (Effect effect : ability.getEffects()) {
            enteringPermanentId = effect.getTargetPointer().getFirst(game, ability);
        }
        if (enteringPermanentId == null) {
            return;
        }
        Permanent enteringPermanent = game.getPermanent(enteringPermanentId);
        if (enteringPermanent == null) {
            return;
        }
        ability.getTargets().clear();
        SharesCardTypePredicate predicate = new SharesCardTypePredicate((Collection)enteringPermanent.getCardType(game));
        FilterPermanent filterTarget = new FilterPermanent(predicate.toString() + " you don't control");
        filterTarget.add((Predicate)predicate);
        filterTarget.add(Predicates.not((Predicate)new ControllerIdPredicate(enteringPermanent.getControllerId())));
        TargetPermanent target = new TargetPermanent(filterTarget);
        target.setTargetController(enteringPermanent.getControllerId());
        ability.getTargets().add((Target)target);
    }
}

