/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class ConjurersBanEffect
extends ContinuousRuleModifyingEffectImpl {
    ConjurersBanEffect() {
        super(Duration.UntilYourNextTurn, Outcome.Detriment, true, false);
        this.staticText = "Until your next turn, spells with the chosen name can't be cast and lands with the chosen name can't be played";
    }

    private ConjurersBanEffect(ConjurersBanEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public ConjurersBanEffect copy() {
        return new ConjurersBanEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL || event.getType() == GameEvent.EventType.PLAY_LAND;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        return CardUtil.haveSameNames((MageObject)object, (String)cardName, (Game)game);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        String playerName = game.getPlayer(source.getControllerId()).getName();
        if (cardName == null || playerName == null || source.getSourceObject(game) == null) {
            return super.getInfoMessage(source, event, game);
        }
        return "Until " + playerName + "'s next turn, spells named " + cardName + " can't be cast and lands named " + cardName + " can't be played (" + source.getSourceObject(game).getIdName() + ").";
    }
}

