/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ConsumeEffect
extends OneShotEffect {
    ConsumeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player sacrifices a creature with the greatest power among creatures they control. You gain life equal to its power.";
    }

    private ConsumeEffect(ConsumeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConsumeEffect copy() {
        return new ConsumeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null || controller == null) {
            return false;
        }
        int greatestPower = 0;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(player.getId())) {
            if (permanent == null || !permanent.isCreature(game)) continue;
            greatestPower = Math.max(permanent.getPower().getValue(), greatestPower);
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with power " + greatestPower);
        filter.add((Predicate)new PowerPredicate(ComparisonType.EQUAL_TO, greatestPower));
        new SacrificeEffect((FilterPermanent)filter, 1, "").apply(game, source);
        controller.gainLife(greatestPower, game, source);
        return true;
    }
}

