/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ConsumingAberrationEffect
extends OneShotEffect {
    ConsumingAberrationEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "each opponent reveals cards from the top of their library until they reveal a land card, then puts those cards into their graveyard";
    }

    private ConsumingAberrationEffect(ConsumingAberrationEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConsumingAberrationEffect copy() {
        return new ConsumingAberrationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(opponentId);
            if (player == null) continue;
            CardsImpl cards = new CardsImpl();
            for (Card card : player.getLibrary().getCards(game)) {
                if (card == null) continue;
                cards.add(card);
                if (!card.isLand(game)) continue;
                break;
            }
            player.revealCards(source, (Cards)cards, game);
            player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        }
        return true;
    }
}

