/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ConsumingAshesEffect
extends OneShotEffect {
    ConsumingAshesEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target creature. If it had mana value 3 or less, surveil 2.";
    }

    private ConsumingAshesEffect(ConsumingAshesEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConsumingAshesEffect copy() {
        return new ConsumingAshesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller == null || permanent == null) {
            return false;
        }
        permanent.moveToExile(null, "", source, game);
        if (permanent.getManaValue() <= 3) {
            controller.surveil(2, source, game);
        }
        return true;
    }
}

