/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ConsumingFerocityEffect
extends OneShotEffect {
    ConsumingFerocityEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that creature has three or more +1/+0 counters on it, it deals damage equal to its power to its controller, then destroy that creature and it can't be regenerated";
    }

    private ConsumingFerocityEffect(ConsumingFerocityEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConsumingFerocityEffect copy() {
        return new ConsumingFerocityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent != null && (creature = game.getPermanent(permanent.getAttachedTo())) != null && creature.getCounters(game).getCount(CounterType.P1P0) > 2) {
            Player player = game.getPlayer(creature.getControllerId());
            if (player != null) {
                player.damage(creature.getPower().getValue(), creature.getId(), source, game);
            }
            DestroyTargetEffect effect = new DestroyTargetEffect(true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
            effect.apply(game, source);
            return true;
        }
        return false;
    }
}

