/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.abilities.effects.common.RollDieWithResultTableEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Boar2Token;
import mage.game.permanent.token.GoatToken;
import mage.game.permanent.token.OxGreenToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ContrabandLivestockEffect
extends RollDieWithResultTableEffect {
    ContrabandLivestockEffect() {
        super(20, "exile target creature, then roll a d20");
        this.addTableEntry(1, 9, new Effect[]{new CreateTokenTargetEffect((Token)new OxGreenToken()).setText("its controller creates a 4/4 green Ox creature token")});
        this.addTableEntry(10, 19, new Effect[]{new CreateTokenTargetEffect((Token)new Boar2Token()).setText("its controller creates a 2/2 green Boar creature token")});
        this.addTableEntry(20, 20, new Effect[]{new CreateTokenTargetEffect((Token)new GoatToken()).setText("its controller creates a 0/1 white Goat creature token")});
    }

    private ContrabandLivestockEffect(ContrabandLivestockEffect effect) {
        super((RollDieWithResultTableEffect)effect);
    }

    public ContrabandLivestockEffect copy() {
        return new ContrabandLivestockEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        int result = player.rollDice(this.outcome, source, game, this.sides);
        this.setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId()));
        this.applyResult(result, game, source);
        return true;
    }
}

