/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Iterator;
import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.RandomUtil;

class ContractualSafeguardSecondEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creature you control with a counter on it");

    ContractualSafeguardSecondEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a kind of counter on a creature you control. Put a counter of that kind on each other creature you control";
        this.concatPrefix = "<br>";
    }

    private ContractualSafeguardSecondEffect(ContractualSafeguardSecondEffect effect) {
        super((OneShotEffect)effect);
    }

    public ContractualSafeguardSecondEffect copy() {
        return new ContractualSafeguardSecondEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String chosenType;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains(filter, source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        LinkedHashSet counterTypes = new LinkedHashSet(permanent.getCounters(game).keySet());
        switch (counterTypes.size()) {
            case 0: {
                return false;
            }
            case 1: {
                chosenType = (String)RandomUtil.randomFromCollection(counterTypes);
                break;
            }
            case 2: {
                Iterator iterator = counterTypes.iterator();
                String type1 = (String)iterator.next();
                String type2 = (String)iterator.next();
                chosenType = player.chooseUse(this.outcome, "Choose which kind of counter to add to each other creature you control", null, type1, type2, source, game) ? type1 : type2;
                break;
            }
            default: {
                ChoiceImpl choice = new ChoiceImpl(true);
                choice.setMessage("Choose a kind of counter to add to each other creature you control");
                choice.setChoices(counterTypes);
                player.choose(this.outcome, (Choice)choice, game);
                chosenType = choice.getChoice();
            }
        }
        CounterType counterType = CounterType.findByName((String)chosenType);
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, source.getControllerId(), source, game)) {
            if (creature.getId().equals(permanent.getId())) continue;
            creature.addCounters(counterType.createInstance(), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

