/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CoordinatedBarrageEffect
extends OneShotEffect {
    CoordinatedBarrageEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose a creature type. {this} deals damage to target attacking or blocking creature equal to the number of permanents you control of the chosen type";
    }

    private CoordinatedBarrageEffect(CoordinatedBarrageEffect effect) {
        super((OneShotEffect)effect);
    }

    public CoordinatedBarrageEffect copy() {
        return new CoordinatedBarrageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ChoiceCreatureType choice;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.choose(Outcome.Damage, (Choice)(choice = new ChoiceCreatureType(game, source)), game)) {
            String chosenType = choice.getChoiceKey();
            FilterControlledPermanent filter = new FilterControlledPermanent();
            filter.add((Predicate)SubType.byDescription((String)chosenType).getPredicate());
            int damageDealt = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                permanent.damage(damageDealt, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

