/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.c.CoramTheUndertakerWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

class CoramTheUndertakerPlayLandFromGraveyardEffect
extends AsThoughEffectImpl {
    CoramTheUndertakerPlayLandFromGraveyardEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "During each of your turns, you may play a land from among cards in graveyards that were put there from libraries this turn.";
    }

    private CoramTheUndertakerPlayLandFromGraveyardEffect(CoramTheUndertakerPlayLandFromGraveyardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public CoramTheUndertakerPlayLandFromGraveyardEffect copy() {
        return new CoramTheUndertakerPlayLandFromGraveyardEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!(source.isControlledBy(affectedControllerId) && affectedControllerId.equals(game.getActivePlayerId()) && Zone.GRAVEYARD.equals((Object)game.getState().getZone(objectId)))) {
            return false;
        }
        CoramTheUndertakerWatcher watcher = (CoramTheUndertakerWatcher)game.getState().getWatcher(CoramTheUndertakerWatcher.class);
        Card card = game.getCard(objectId);
        return card != null && watcher != null && watcher.cardPutFromGraveyardThisTurn(new MageObjectReference((MageObject)card.getMainCard(), game)) && card.isLand(game) && !watcher.landPlayedFromGraveyard(source, game);
    }
}

