/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class CorpseAppraiserEffect
extends OneShotEffect {
    CorpseAppraiserEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target creature card from a graveyard. If a card is put into exile this way, look at the top three cards of your library, then put one of those cards into your hand and the rest into your graveyard";
    }

    private CorpseAppraiserEffect(CorpseAppraiserEffect effect) {
        super((OneShotEffect)effect);
    }

    public CorpseAppraiserEffect copy() {
        return new CorpseAppraiserEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (!Zone.EXILED.match(game.getState().getZone(card.getId()))) {
            return true;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        if (cards.isEmpty()) {
            return true;
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        player.moveCards(cards.get(target.getFirstTarget(), game), Zone.HAND, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        return true;
    }
}

