/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CorpseLungeEffect
extends OneShotEffect {
    CorpseLungeEffect() {
        super(Outcome.DrawCard);
        this.staticText = "{this} deals damage equal to the exiled card's power to target creature";
    }

    private CorpseLungeEffect(CorpseLungeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CorpseLungeEffect copy() {
        return new CorpseLungeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        int amount = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof ExileFromGraveCost)) continue;
            Card card = game.getCard(cost.getTargets().getFirstTarget());
            if (card == null) break;
            amount = card.getPower().getValue();
            break;
        }
        if (amount > 0 && (permanent = game.getPermanent(source.getFirstTarget())) != null) {
            permanent.damage(amount, source.getSourceId(), source, game, false, true);
            return true;
        }
        return false;
    }
}

