/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class CorrosiveOozeCombatWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<MageObjectReference>> oozeBlocksOrBlocked = new HashMap<MageObjectReference, Set<MageObjectReference>>();
    private final Map<MageObjectReference, Set<MageObjectReference>> oozeEquipmentsToDestroy = new HashMap<MageObjectReference, Set<MageObjectReference>>();

    CorrosiveOozeCombatWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.BEGIN_COMBAT_STEP_PRE) {
            this.oozeBlocksOrBlocked.clear();
            return;
        }
        if (event.getType() == GameEvent.EventType.BLOCKER_DECLARED) {
            Permanent attacker = game.getPermanent(event.getTargetId());
            Permanent blocker = game.getPermanent(event.getSourceId());
            if (attacker == null || blocker == null) {
                return;
            }
            this.oozeBlocksOrBlocked.computeIfAbsent(new MageObjectReference((MageObject)attacker, game), k -> new HashSet()).add(new MageObjectReference((MageObject)blocker, game));
            this.oozeBlocksOrBlocked.computeIfAbsent(new MageObjectReference((MageObject)blocker, game), k -> new HashSet()).add(new MageObjectReference((MageObject)attacker, game));
            return;
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD) {
            for (Map.Entry<MageObjectReference, Set<MageObjectReference>> entry : this.oozeBlocksOrBlocked.entrySet()) {
                for (MageObjectReference mor : entry.getValue()) {
                    if (!mor.refersTo((MageObject)zEvent.getTarget(), game)) continue;
                    zEvent.getTarget().getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(a -> a.hasSubtype(SubType.EQUIPMENT, game)).map(a -> new MageObjectReference((MageObject)a, game)).forEach(this.oozeEquipmentsToDestroy.computeIfAbsent(entry.getKey(), k -> new HashSet())::add);
                }
            }
        }
    }

    public void reset() {
        super.reset();
        this.oozeBlocksOrBlocked.clear();
        this.oozeEquipmentsToDestroy.clear();
    }

    Set<MageObjectReference> getRelatedBlockedCreatures(MageObjectReference ooze) {
        return this.oozeBlocksOrBlocked.getOrDefault(ooze, Collections.emptySet());
    }

    Set<MageObjectReference> getEquipmentsToDestroy(MageObjectReference ooze) {
        return this.oozeEquipmentsToDestroy.getOrDefault(ooze, Collections.emptySet());
    }
}

