/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CorruptEffect
extends OneShotEffect {
    private static final FilterLandPermanent filter = new FilterLandPermanent("Swamps");

    public CorruptEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to any target equal to the number of Swamps you control. You gain life equal to the damage dealt this way";
    }

    private CorruptEffect(CorruptEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int amount = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
        if (amount > 0) {
            int damageDealt = amount;
            Permanent permanent = game.getPermanent(source.getFirstTarget());
            if (permanent != null) {
                damageDealt = permanent.damage(amount, source.getSourceId(), source, game, false, true);
            } else {
                Player player = game.getPlayer(source.getFirstTarget());
                if (player != null) {
                    damageDealt = player.damage(amount, source.getSourceId(), source, game);
                } else {
                    return false;
                }
            }
            Player you = game.getPlayer(source.getControllerId());
            if (you != null) {
                you.gainLife(damageDealt, game, source);
                return true;
            }
        }
        return false;
    }

    public CorruptEffect copy() {
        return new CorruptEffect(this);
    }

    static {
        filter.add((Predicate)SubType.SWAMP.getPredicate());
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

