/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class CorruptedResolveEffect
extends OneShotEffect {
    CorruptedResolveEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell if its controller is poisoned";
    }

    private CorruptedResolveEffect(CorruptedResolveEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null && (player = game.getPlayer(spell.getControllerId())) != null && player.getCountersCount(CounterType.POISON) > 0) {
            return game.getStack().counter(this.getTargetPointer().getFirst(game, source), source, game);
        }
        return false;
    }

    public CorruptedResolveEffect copy() {
        return new CorruptedResolveEffect(this);
    }
}

