/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CosmiumConfluenceEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.CAVE, "Cave you control");

    CosmiumConfluenceEffect() {
        super(Outcome.BecomeCreature);
        this.staticText = "put three +1/+1 counters on a Cave you control. It becomes a 0/0 Elemental creature with haste. It's still a land";
    }

    private CosmiumConfluenceEffect(CosmiumConfluenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CosmiumConfluenceEffect copy() {
        return new CosmiumConfluenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        if (!target.canChoose(controller.getId(), source, game)) {
            return false;
        }
        controller.choose(this.outcome, (Target)target, source, game);
        FixedTarget blueprintTarget = new FixedTarget(target.getFirstTarget(), game);
        new AddCountersTargetEffect(CounterType.P1P1.createInstance(3)).setTargetPointer((TargetPointer)blueprintTarget.copy()).apply(game, source);
        BecomesCreatureTargetEffect effect = new BecomesCreatureTargetEffect((Token)new CreatureToken(0, 0, "0/0 Elemental creature with haste", new SubType[]{SubType.ELEMENTAL}).withAbility((Ability)HasteAbility.getInstance()), false, true, Duration.Custom);
        effect.setTargetPointer((TargetPointer)blueprintTarget.copy());
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

