/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.c.CouncilGuardianVote;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class CouncilsGuardianEffect
extends OneShotEffect {
    CouncilsGuardianEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for blue, black, red, or green. {this} gains protection from each color with the most votes or tied for most votes";
    }

    private CouncilsGuardianEffect(CouncilsGuardianEffect effect) {
        super((OneShotEffect)effect);
    }

    public CouncilsGuardianEffect copy() {
        return new CouncilsGuardianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CouncilGuardianVote vote = new CouncilGuardianVote();
        vote.doVotes(source, game);
        for (String color : vote.getMostVoted()) {
            if (color == null) continue;
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)ProtectionAbility.from((ObjectColor)ChoiceColor.getColorFromString((String)color)), Duration.Custom), source);
        }
        return true;
    }
}

