/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class CounterpointEffect
extends OneShotEffect {
    private static final FilterCard baseFilter = new FilterCard();

    CounterpointEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter target spell. You may cast a creature, instant, sorcery, or planeswalker spell from your graveyard with mana value less than or equal to that spell's mana value without paying its mana cost";
    }

    private CounterpointEffect(CounterpointEffect effect) {
        super((OneShotEffect)effect);
    }

    public CounterpointEffect copy() {
        return new CounterpointEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (player == null || spell == null) {
            return false;
        }
        int mv = spell.getManaValue();
        game.getStack().counter(spell.getId(), source, game);
        CardsImpl cards = new CardsImpl((Collection)player.getGraveyard());
        FilterCard filter = baseFilter.copy();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, mv + 1));
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)filter);
        return true;
    }

    static {
        baseFilter.add(Predicates.or((Predicate[])new Predicate[]{CardType.CREATURE.getPredicate(), CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate(), CardType.PLANESWALKER.getPredicate()}));
    }
}

