/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CountrysideCrusherEffect
extends OneShotEffect {
    CountrysideCrusherEffect() {
        super(Outcome.Discard);
        this.staticText = "reveal the top card of your library. If it's a land card, put it into your graveyard and repeat this process";
    }

    private CountrysideCrusherEffect(CountrysideCrusherEffect effect) {
        super((OneShotEffect)effect);
    }

    public CountrysideCrusherEffect copy() {
        return new CountrysideCrusherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller == null || sourcePermanent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Card card : controller.getLibrary().getCards(game)) {
            cards.add(card);
            if (!card.isLand(game)) break;
            controller.moveCards(card, Zone.GRAVEYARD, source, game);
        }
        controller.revealCards(sourcePermanent.getName(), (Cards)cards, game);
        return true;
    }
}

