/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;
import mage.util.CardUtil;

class CourtOfAmbitionEffect
extends OneShotEffect {
    CourtOfAmbitionEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent loses 3 life unless they discard a card. If you're the monarch, instead each opponent loses 6 life unless they discard two cards";
    }

    private CourtOfAmbitionEffect(CourtOfAmbitionEffect effect) {
        super((OneShotEffect)effect);
    }

    public CourtOfAmbitionEffect copy() {
        return new CourtOfAmbitionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        int discardCount = source.isControlledBy(game.getMonarchId()) ? 2 : 1;
        String message = "Discard " + CardUtil.numberToText((int)discardCount, (String)"a") + " card" + (discardCount > 1 ? Character.valueOf('s') : "") + "? If not you lose " + discardCount * 3 + " life";
        HashMap<UUID, CardsImpl> discardMap = new HashMap<UUID, CardsImpl>();
        for (UUID uUID : game.getOpponents(source.getControllerId())) {
            player = game.getPlayer(uUID);
            if (player == null) continue;
            if (player.getHand().size() < discardCount || !player.chooseUse(Outcome.LoseLife, message, source, game)) {
                player.loseLife(discardCount * 3, game, source, false);
                continue;
            }
            TargetDiscard target = new TargetDiscard(discardCount, StaticFilters.FILTER_CARD, uUID);
            player.choose(Outcome.Discard, (Target)target, source, game);
            discardMap.put(uUID, new CardsImpl((Collection)target.getTargets()));
        }
        for (Map.Entry entry : discardMap.entrySet()) {
            player = game.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            player.discard((Cards)entry.getValue(), false, source, game);
        }
        return true;
    }
}

