/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class CourtOfCunningEffect
extends OneShotEffect {
    CourtOfCunningEffect() {
        super(Outcome.Benefit);
        this.staticText = "any number of target players each mill two cards. If you're the monarch, each of those players mills ten cards instead";
    }

    private CourtOfCunningEffect(CourtOfCunningEffect effect) {
        super((OneShotEffect)effect);
    }

    public CourtOfCunningEffect copy() {
        return new CourtOfCunningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean isMonarch = source.isControlledBy(game.getMonarchId());
        for (Player player : source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toList())) {
            player.millCards(isMonarch ? 10 : 2, source, game);
        }
        return true;
    }
}

