/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class CovetousUrgeEffect
extends OneShotEffect {
    CovetousUrgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent reveals their hand. You choose a nonland card from that player's graveyard or hand and exile it. You may cast that card for as long as it remains exiled, and you may spend mana as though it were mana of any color to cast that spell.";
    }

    private CovetousUrgeEffect(CovetousUrgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CovetousUrgeEffect copy() {
        return new CovetousUrgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCard target;
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        player.revealCards(source, player.getHand(), game);
        if (player.getGraveyard().isEmpty() || controller.chooseUse(Outcome.Benefit, "Exile a nonland card from " + player.getName() + "'s hand or graveyard", "", "Hand", "Graveyard", source, game)) {
            if (player.getHand().isEmpty()) {
                return true;
            }
            target = new TargetCard(Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
            controller.choose(Outcome.Exile, player.getHand(), target, source, game);
        } else {
            target = new TargetCard(Zone.GRAVEYARD, (FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
            controller.choose(Outcome.Exile, (Cards)player.getGraveyard(), target, source, game);
        }
        UUID exileZone = CardUtil.getExileZoneId((String)(controller.getId() + " - Covetous Urge"), (Game)game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null || !controller.moveCardsToExile(card, source, game, true, exileZone, "Covetous Urge - can cast with any mana")) {
            return false;
        }
        if (card.getSpellAbility() == null) {
            return true;
        }
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.Custom, (boolean)true);
        return true;
    }
}

