/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.token.InsectToken;
import mage.game.permanent.token.Token;

class CrawlingInfestationTriggeredAbility
extends TriggeredAbilityImpl {
    public CrawlingInfestationTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new InsectToken()));
        this.setTriggersLimitEachTurn(1);
        this.setTriggerPhrase("Whenever one or more creature cards are put into your graveyard from anywhere during your turn, ");
    }

    private CrawlingInfestationTriggeredAbility(CrawlingInfestationTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CrawlingInfestationTriggeredAbility copy() {
        return new CrawlingInfestationTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() == Zone.GRAVEYARD && game.isActivePlayer(this.controllerId)) {
            Card card = game.getCard(zEvent.getTargetId());
            return card != null && !card.isCopy() && card.isCreature(game) && card.isOwnedBy(this.controllerId);
        }
        return false;
    }
}

