/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;
import mage.game.permanent.token.InsectToken;
import mage.game.permanent.token.Token;

class CrawlingSensationTriggeredAbility
extends TriggeredAbilityImpl {
    public CrawlingSensationTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new InsectToken()), false);
    }

    private CrawlingSensationTriggeredAbility(CrawlingSensationTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Integer usedOnTurn;
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent != null && Zone.GRAVEYARD == zEvent.getToZone() && zEvent.getCards() != null && ((usedOnTurn = (Integer)game.getState().getValue("usedOnTurn" + this.getControllerId() + this.getOriginalId())) == null || usedOnTurn < game.getTurnNum())) {
            for (Card card : zEvent.getCards()) {
                UUID cardOwnerId;
                if (card == null || (cardOwnerId = card.getOwnerId()) == null || !card.isOwnedBy(this.getControllerId()) || !card.isLand(game)) continue;
                game.getState().setValue("usedOnTurn" + this.getControllerId() + this.getOriginalId(), (Object)game.getTurnNum());
                return true;
            }
        }
        return false;
    }

    public CrawlingSensationTriggeredAbility copy() {
        return new CrawlingSensationTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more land cards are put into your graveyard from anywhere for the first time each turn, create a 1/1 green Insect creature token.";
    }
}

