/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CreativeTechniqueEffect
extends OneShotEffect {
    CreativeTechniqueEffect() {
        super(Outcome.Benefit);
        this.staticText = "shuffle your library, then reveal cards from the top of it until you reveal a nonland card. Exile that card and put the rest on the bottom of your library in a random order. You may cast the exiled card without paying its mana cost";
    }

    private CreativeTechniqueEffect(CreativeTechniqueEffect effect) {
        super((OneShotEffect)effect);
    }

    public CreativeTechniqueEffect copy() {
        return new CreativeTechniqueEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.shuffleLibrary(source, game);
        CardsImpl cards = new CardsImpl();
        Card toCast = null;
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (card.isLand(game)) continue;
            toCast = card;
            break;
        }
        player.revealCards(source, (Cards)cards, game);
        cards.remove(toCast);
        if (toCast != null) {
            player.moveCards(toCast, Zone.EXILED, source, game);
        }
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Card)toCast);
        return true;
    }
}

