/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.util.ManaUtil;

class CrookedScalesEffect
extends OneShotEffect {
    CrookedScalesEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Flip a coin. If you win the flip, destroy target creature an opponent controls. If you lose the flip, destroy target creature you control unless you pay {3} and repeat this process";
    }

    private CrookedScalesEffect(CrookedScalesEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrookedScalesEffect copy() {
        return new CrookedScalesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            boolean keepGoing;
            Permanent yourGuy = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            Permanent theirGuy = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
            String message = "You lost the flip. Pay {3} to prevent your creature from being destroyed?";
            do {
                if (controller.flipCoin(source, game, true)) {
                    if (theirGuy != null) {
                        theirGuy.destroy(source, game, false);
                    }
                    keepGoing = false;
                    continue;
                }
                ManaCost cost = ManaUtil.createManaCost((int)3, (boolean)false);
                if (!controller.chooseUse(Outcome.Benefit, message, source, game) || !cost.pay(source, game, source, controller.getId(), false, null)) {
                    if (yourGuy != null) {
                        yourGuy.destroy(source, game, false);
                    }
                    keepGoing = false;
                    continue;
                }
                keepGoing = true;
            } while (keepGoing && controller.canRespond());
            return true;
        }
        return false;
    }
}

