/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CrownOfConvergenceEffect
extends OneShotEffect {
    CrownOfConvergenceEffect() {
        super(Outcome.Neutral);
        this.staticText = "Put the top card of your library on the bottom of your library";
    }

    private CrownOfConvergenceEffect(CrownOfConvergenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrownOfConvergenceEffect copy() {
        return new CrownOfConvergenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                controller.putCardsOnBottomOfLibrary((Cards)new CardsImpl(card), game, source, true);
            }
            return true;
        }
        return false;
    }
}

