/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CrownOfEmpiresControlEffect
extends ContinuousEffectImpl {
    CrownOfEmpiresControlEffect() {
        super(Duration.EndOfGame, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.staticText = "Gain control of {this}";
    }

    private CrownOfEmpiresControlEffect(CrownOfEmpiresControlEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public CrownOfEmpiresControlEffect copy() {
        return new CrownOfEmpiresControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        UUID controllerId = (UUID)game.getState().getValue(source.getSourceId().toString());
        if (permanent != null && controllerId != null) {
            return permanent.changeControllerId(controllerId, game, source);
        }
        return false;
    }
}

