/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.players.Player;

class CruelEntertainmentEffect
extends OneShotEffect {
    CruelEntertainmentEffect() {
        super(Outcome.Detriment);
        this.staticText = "Choose target player and another target player. The first player controls the second player during the second player's next turn, and the second player controls the first player during the first player's next turn";
    }

    private CruelEntertainmentEffect(CruelEntertainmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public CruelEntertainmentEffect copy() {
        return new CruelEntertainmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player1 = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player player2 = null;
        if (this.getTargetPointer().getTargets(game, source).size() > 1) {
            player2 = game.getPlayer((UUID)this.getTargetPointer().getTargets(game, source).get(1));
        }
        if (player1 != null && player2 != null) {
            game.getState().getTurnMods().add(new TurnMod(player1.getId()).withNewController(player2.getId()));
            game.getState().getTurnMods().add(new TurnMod(player2.getId()).withNewController(player1.getId()));
            return true;
        }
        return false;
    }
}

