/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class CruelFateEffect
extends OneShotEffect {
    CruelFateEffect() {
        super(Outcome.Detriment);
        this.staticText = "Look at the top five cards of target opponent's library. Put one of those cards into that player's graveyard and the rest on top of their library in any order";
    }

    private CruelFateEffect(CruelFateEffect effect) {
        super((OneShotEffect)effect);
    }

    public CruelFateEffect copy() {
        return new CruelFateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(opponent.getLibrary().getTopCards(game, 5));
        if (cards.isEmpty()) {
            return false;
        }
        if (cards.size() == 1) {
            return controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        }
        TargetCardInLibrary targetCard = new TargetCardInLibrary();
        controller.choose(this.outcome, (Cards)cards, (TargetCard)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card != null) {
            controller.moveCards(card, Zone.GRAVEYARD, source, game);
            cards.remove(card);
        }
        return controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
    }
}

