/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class CruelGrimnarchEffect
extends OneShotEffect {
    CruelGrimnarchEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent discards a card. For each opponent who can't, you gain 4 life";
    }

    private CruelGrimnarchEffect(CruelGrimnarchEffect effect) {
        super((OneShotEffect)effect);
    }

    public CruelGrimnarchEffect copy() {
        return new CruelGrimnarchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        HashMap<UUID, CardsImpl> cardsToDiscard = new HashMap<UUID, CardsImpl>();
        for (UUID playerId : game.getOpponents(source.getControllerId(), true)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            int numberOfCardsToDiscard = Math.min(1, player.getHand().size());
            CardsImpl cards = new CardsImpl();
            TargetDiscard target = new TargetDiscard(numberOfCardsToDiscard, numberOfCardsToDiscard, StaticFilters.FILTER_CARD, playerId);
            player.chooseTarget(this.outcome, (Target)target, source, game);
            cards.addAll((Collection)target.getTargets());
            cardsToDiscard.put(playerId, cards);
        }
        for (UUID playerId : game.getOpponents(source.getControllerId(), true)) {
            int amountDiscarded;
            player = game.getPlayer(playerId);
            if (player == null || (amountDiscarded = player.discard((Cards)cardsToDiscard.get(playerId), false, source, game).size()) != 0 || controller == null) continue;
            controller.gainLife(4, game, source);
        }
        return true;
    }
}

