/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class CruelRealityEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("creature or planeswalker");

    CruelRealityEffect() {
        super(Outcome.LoseLife);
        this.staticText = "that player sacrifices a creature or planeswalker. If the player can't, they lose 5 life";
    }

    private CruelRealityEffect(CruelRealityEffect effect) {
        super((OneShotEffect)effect);
    }

    public CruelRealityEffect copy() {
        return new CruelRealityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent objectToBeSacrificed;
        Player cursedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (cursedPlayer == null || controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(filter);
        if (target.canChoose(cursedPlayer.getId(), source, game) && cursedPlayer.choose(Outcome.Sacrifice, (Target)target, source, game) && (objectToBeSacrificed = game.getPermanent(target.getFirstTarget())) != null && objectToBeSacrificed.sacrifice(source, game)) {
            return true;
        }
        cursedPlayer.loseLife(5, game, source, false);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

