/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class CrumblingSanctuaryEffect
extends PreventionEffectImpl {
    CrumblingSanctuaryEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false, false);
        this.staticText = "If damage would be dealt to a player, that player exiles that many cards from the top of their library instead.";
    }

    private CrumblingSanctuaryEffect(CrumblingSanctuaryEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public CrumblingSanctuaryEffect copy() {
        return new CrumblingSanctuaryEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int amount = event.getAmount();
        Player player = game.getPlayer(event.getTargetId());
        if (player != null) {
            this.preventDamageAction(event, source, game);
            player.moveCards(player.getLibrary().getTopCards(game, amount), Zone.EXILED, source, game);
            return true;
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && game.getPlayer(event.getTargetId()) != null;
    }
}

