/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.CardsPutIntoGraveyardWatcher;

class CryOfTheCarnariumExileEffect
extends OneShotEffect {
    CryOfTheCarnariumExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile all creature cards in all graveyards that were put there from the battlefield this turn.";
    }

    private CryOfTheCarnariumExileEffect(CryOfTheCarnariumExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public CryOfTheCarnariumExileEffect copy() {
        return new CryOfTheCarnariumExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        CardsPutIntoGraveyardWatcher watcher = (CardsPutIntoGraveyardWatcher)game.getState().getWatcher(CardsPutIntoGraveyardWatcher.class);
        if (controller == null || watcher == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(watcher.getCardsPutIntoGraveyardFromBattlefield(game));
        cards.removeIf(uuid -> !game.getCard(uuid).isCreature(game));
        return controller.moveCards((Cards)cards, Zone.EXILED, source, game);
    }
}

