/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesCreatureTypePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class CrypticGatewayEffect
extends OneShotEffect {
    CrypticGatewayEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may put a creature card from your hand that shares a creature type with each creature tapped this way onto the battlefield";
    }

    private CrypticGatewayEffect(CrypticGatewayEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrypticGatewayEffect copy() {
        return new CrypticGatewayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List tapped = (List)this.getValue("tappedPermanents");
        if (tapped == null || tapped.isEmpty()) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard("creature card that shares a creature type with " + CardUtil.concatWithAnd(tapped.stream().map(MageObject::getName).collect(Collectors.toList())));
        for (Permanent perm : tapped) {
            filter.add((Predicate)new SharesCreatureTypePredicate(perm));
        }
        return new PutCardFromHandOntoBattlefieldEffect((FilterCard)filter).apply(game, source);
    }
}

