/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CulturalExchangeEffect
extends OneShotEffect {
    CulturalExchangeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose any number of creatures target player controls. Choose the same number of creatures another target player controls. Those players exchange control of those creatures.";
    }

    private CulturalExchangeEffect(CulturalExchangeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CulturalExchangeEffect copy() {
        return new CulturalExchangeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int otherToSwitch;
        TargetPermanent target2;
        Player player1 = game.getPlayer((UUID)this.getTargetPointer().getTargets(game, source).get(0));
        Player player2 = game.getPlayer((UUID)this.getTargetPointer().getTargets(game, source).get(1));
        Player controller = game.getPlayer(source.getControllerId());
        if (player1 == null || player2 == null || controller == null) {
            return false;
        }
        FilterCreaturePermanent filter1 = new FilterCreaturePermanent("creatures " + player1.getLogName() + " controls");
        FilterCreaturePermanent filter2 = new FilterCreaturePermanent("creatures " + player2.getLogName() + " controls");
        filter1.add((Predicate)new ControllerIdPredicate(player1.getId()));
        filter2.add((Predicate)new ControllerIdPredicate(player2.getId()));
        int creatureCount1 = game.getBattlefield().count((FilterPermanent)filter1, source.getControllerId(), source, game);
        int creatureCount2 = game.getBattlefield().count((FilterPermanent)filter2, source.getControllerId(), source, game);
        int creaturesToSwitch = Math.min(creatureCount1, creatureCount2);
        if (creaturesToSwitch == 0) {
            return true;
        }
        TargetPermanent target1 = new TargetPermanent(0, creaturesToSwitch, (FilterPermanent)filter1, true);
        if (target1.choose(Outcome.Benefit, controller.getId(), source.getSourceId(), source, game) && (target2 = new TargetPermanent(otherToSwitch = target1.getTargets().size(), otherToSwitch, (FilterPermanent)filter2, true)).choose(Outcome.Benefit, controller.getId(), source.getSourceId(), source, game)) {
            GainControlTargetEffect effect;
            Permanent creature;
            for (UUID creatureId : target1.getTargets()) {
                creature = game.getPermanent(creatureId);
                if (creature == null) continue;
                effect = new GainControlTargetEffect(Duration.Custom, player2.getId());
                game.informPlayers(player2.getLogName() + " gains control of " + creature.getLogName());
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            for (UUID creatureId : target2.getTargets()) {
                creature = game.getPermanent(creatureId);
                if (creature == null) continue;
                effect = new GainControlTargetEffect(Duration.Custom, player1.getId());
                game.informPlayers(player1.getLogName() + " gains control of " + creature.getLogName());
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return true;
    }
}

