/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class CuratorOfDestiniesEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("cards for the face-down pile");

    CuratorOfDestiniesEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top five cards of your library and separate them into a face-down pile and a face-up pile. An opponent chooses one of those piles. Put that pile into your hand and the other into your graveyard";
    }

    private CuratorOfDestiniesEffect(CuratorOfDestiniesEffect effect) {
        super((OneShotEffect)effect);
    }

    public CuratorOfDestiniesEffect copy() {
        return new CuratorOfDestiniesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 5));
        TargetCard target = new TargetCard(0, Integer.MAX_VALUE, Zone.LIBRARY, filter);
        controller.choose(this.outcome, (Cards)cards, target, source, game);
        CardsImpl faceDownPile = new CardsImpl((Collection)target.getTargets());
        cards.removeAll((Collection)target.getTargets());
        controller.revealCards(sourceObject.getIdName() + " - face-up pile", (Cards)cards, game);
        game.informPlayers(controller.getLogName() + " puts " + faceDownPile.size() + " card" + (faceDownPile.size() == 1 ? "" : "s") + " into the face-down pile");
        Set opponents = game.getOpponents(controller.getId());
        if (opponents.size() == 1) {
            opponent = game.getPlayer((UUID)opponents.iterator().next());
        } else {
            TargetOpponent targetOpponent = new TargetOpponent(true);
            controller.chooseTarget(Outcome.Detriment, (Target)targetOpponent, source, game);
            opponent = game.getPlayer(targetOpponent.getFirstTarget());
        }
        if (opponent == null) {
            return false;
        }
        boolean choice = opponent.chooseUse(this.outcome, "Choose a pile to put into " + controller.getLogName() + "'s hand.", null, "Face-down", "Face-up", source, game);
        controller.moveCards((Cards)faceDownPile, choice ? Zone.HAND : Zone.GRAVEYARD, source, game);
        controller.moveCards((Cards)cards, choice ? Zone.GRAVEYARD : Zone.HAND, source, game);
        return true;
    }
}

