/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.token.RogueToken;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class CurrencyConverterTokenEffect
extends OneShotEffect {
    CurrencyConverterTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a card exiled with {this} into your graveyard. If it's a land card, create a Treasure token. If it's a nonland card, create a 2/2 black Rogue creature token";
    }

    private CurrencyConverterTokenEffect(CurrencyConverterTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurrencyConverterTokenEffect copy() {
        return new CurrencyConverterTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getState().getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (player == null || exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        if (exileZone.size() > 1) {
            TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD);
            player.choose(this.outcome, (Cards)exileZone, (TargetCard)target, source, game);
            card = exileZone.get(target.getFirstTarget(), game);
        } else {
            card = exileZone.getRandom(game);
        }
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.GRAVEYARD, source, game);
        TreasureToken token = card.isLand(game) ? new TreasureToken() : new RogueToken();
        token.putOntoBattlefield(1, game, source);
        return true;
    }
}

