/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CurseOfConformityEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent();

    CurseOfConformityEffect() {
        super(Duration.WhileOnBattlefield, Outcome.LoseAbility);
        this.staticText = "nonlegendary creatures enchanted player controls have base power and toughness 3/3 and lose all creature types";
    }

    private CurseOfConformityEffect(CurseOfConformityEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public CurseOfConformityEffect copy() {
        return new CurseOfConformityEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.removeAllCreatureTypes(game);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(3);
                    permanent.getToughness().setModifiedBaseValue(3);
                }
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.PTChangingEffects_7;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.LEGENDARY.getPredicate()));
        filter.add((ObjectSourcePlayerPredicate)TargetController.ENCHANTED.getControllerPredicate());
    }
}

