/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CurseOfEchoesEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfEchoesCopyTriggeredAbility
extends TriggeredAbilityImpl {
    CurseOfEchoesCopyTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CurseOfEchoesEffect(), false);
        this.setTriggerPhrase("Whenever enchanted player casts an instant or sorcery spell, ");
    }

    private CurseOfEchoesCopyTriggeredAbility(CurseOfEchoesCopyTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CurseOfEchoesCopyTriggeredAbility copy() {
        return new CurseOfEchoesCopyTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player;
        Permanent enchantment;
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && spell.isInstantOrSorcery(game) && (enchantment = game.getPermanent(this.sourceId)) != null && enchantment.getAttachedTo() != null && (player = game.getPlayer(enchantment.getAttachedTo())) != null && spell.isControlledBy(player.getId())) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(spell.getId()));
            return true;
        }
        return false;
    }
}

